#include <bits/stdc++.h>
using namespace std;

struct Jar { long long x, h; };

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<Jar> a(n);
    for (int i = 0; i < n; i++) cin >> a[i].x;
    for (int i = 0; i < n; i++) cin >> a[i].h;

    sort(a.begin(), a.end(), [](auto &A, auto &B) {
        return A.x < B.x;
    });

    const long long INF = 4e18;
    vector<long long> ans(n, INF);

    stack<int> st;
    for (int i = 0; i < n; i++) {
        while (!st.empty() && a[st.top()].h <= a[i].h) {
            int j = st.top(); st.pop();
            ans[j] = min(ans[j], llabs(a[i].x - a[j].x));
        }
        st.push(i);
    }

    stack<int> st2;
    for (int i = n - 1; i >= 0; i--) {
        while (!st2.empty() && a[st2.top()].h <= a[i].h) {
            int j = st2.top(); st2.pop();
            ans[j] = min(ans[j], llabs(a[i].x - a[j].x));
        }
        st2.push(i);
    }

    for (int i = 0; i + 1 < n; i++) {
        long long x1 = a[i].x,     h1 = a[i].h;
        long long x2 = a[i+1].x,   h2 = a[i+1].h;

        if (h2 >= h1) {
            long long xt = x2 - (h2 - h1);
            ans[i] = min(ans[i], llabs(xt - x1));
        }

        if (h1 >= h2) {
            long long xt = x1 + (h1 - h2);
            ans[i+1] = min(ans[i+1], llabs(xt - x2));
        }
    }

    for (int i = 0; i < n; i++) {
        if (ans[i] > 3e18) cout << -1 << "\n";
        else cout << ans[i] << "\n";
    }
}